package entities;

import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@NamedQueries({
	@NamedQuery(name="Employee.selectWithSalaryGreaterThan", query="Select e from Employee e where e.salary > :salary"),
	@NamedQuery(name="Employee.selectAllNames", query="Select e.name from Employee e"),
	@NamedQuery(name="Employee.selectAllNamesAndBirthday", query="Select e.name, e.birthday from Employee e")
})
public class Employee {

	@Id
	@GeneratedValue
	private long id;
	
	@Column(nullable=false)
	private String name;
	
	@Temporal(value=TemporalType.DATE)
	private Date birthday;
	
	private double salary;
	
	@ManyToMany(cascade=CascadeType.PERSIST)
	private List<Project> projects;
	
	@OneToOne(cascade = CascadeType.PERSIST)
	private Address address;
	
	public Employee(String name, Date birthday, double salary, List<Project> projects) {
		this.birthday = birthday;
		this.salary = salary;
		this.name = name;
		this.projects = projects;
	}
	
	public Employee(String name, Date birthday, double salary, Address address) {
		this.birthday = birthday;
		this.salary = salary;
		this.name = name;
		this.address = address;
	}
	
	public Employee(String name, Date birthday, double salary) {
		this.birthday = birthday;
		this.salary = salary;
		this.name = name;
	}

	public Employee() {
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	public double getSalary() {
		return salary;
	}

	public void setSalary(double salary) {
		this.salary = salary;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public List<Project> getProjects() {
		return projects;
	}

	public void setProjects(List<Project> projects) {
		this.projects = projects;
	}

	public String toString(){
		return "name: " + name + ", salary:" + salary + ", birthday: " + birthday + ", projects: " + projects + ", address[" + address + "]"; 
	}

	public Address getAddress() {
		return address;
	}

	public void setAddress(Address address) {
		this.address = address;
	}

}
